<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id');
            
            // Sender info
            $table->string('sender_type')->nullable(); // 'admin', 'employee', or 'system'
            $table->unsignedBigInteger('sender_id')->nullable(); // admin.id or employee.employee_id
            
            // Receiver info  
            $table->string('receiver_type'); // 'admin' or 'employee'
            $table->unsignedBigInteger('receiver_id'); // admin.id or employee.employee_id
            
            // Notification content
            $table->string('title');
            $table->text('content');
            
            // Status
            $table->boolean('is_read')->default(false);
            $table->timestamp('read_at')->nullable();
            
            // Optional: Reference to related entities
            $table->string('type')->default('general'); // 'chat', 'announcement', 'reminder', etc.
            $table->unsignedBigInteger('related_id')->nullable(); // conversation_id, message_id, etc.
            
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['receiver_type', 'receiver_id', 'is_read']);
            $table->index(['tenant_id', 'receiver_type', 'receiver_id']);
            $table->index(['created_at']);
            $table->index(['type', 'related_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};