<?php
// database/migrations/xxxx_create_push_subscriptions_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePushSubscriptionsTable extends Migration
{
    public function up()
    {
        Schema::create('push_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id');
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->unsignedBigInteger('admin_id')->nullable();
            $table->string('endpoint');
            $table->string('public_key')->nullable();
            $table->string('auth_token')->nullable();
            $table->string('content_encoding')->default('aesgcm');
            $table->timestamps();

            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');
            $table->foreign('employee_id')->references('employee_id')->on('employees')->onDelete('cascade');
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('cascade');
            
            // Ensure one user per subscription
            $table->unique(['tenant_id', 'employee_id', 'endpoint']);
            $table->unique(['tenant_id', 'admin_id', 'endpoint']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('push_subscriptions');
    }
}