<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('youtube_videos', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('youtube_url');
            $table->string('video_id', 20)->unique();
            $table->text('thumbnail_url')->nullable();
            $table->text('description')->nullable();
            $table->integer('duration')->nullable(); // in seconds
            $table->string('channel_name')->nullable();
            $table->boolean('is_active')->default(true);
            $table->foreignId('added_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['is_active', 'created_at']);
            $table->index('added_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('youtube_videos');
    }
};