<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConversationsTable extends Migration
{
    public function up()
    {
        Schema::create('conversations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id');
            $table->enum('type', ['personal', 'group'])->default('personal');
            $table->string('name')->nullable(); // For group chats
            $table->text('description')->nullable(); // For group chats
            $table->string('avatar')->nullable(); // For group chats
            $table->unsignedBigInteger('created_by')->nullable(); // Employee who created the group
            $table->timestamp('last_message_at')->nullable();
            $table->timestamps();
            
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');
            $table->foreign('created_by')->references('employee_id')->on('employees')->onDelete('set null');
            $table->index(['tenant_id', 'last_message_at']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('conversations');
    }
}