<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('chats', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('sender_id');
            $table->unsignedBigInteger('receiver_id');
            $table->text('message')->nullable();
            $table->string('attachment')->nullable(); // optional file
            $table->enum('status', ['sent', 'delivered', 'read'])->default('sent');

            $table->timestamps();

            // Foreign keys referring to employee_id (not id)
            $table->foreign('sender_id')->references('employee_id')->on('employees')->onDelete('cascade');
            $table->foreign('receiver_id')->references('employee_id')->on('employees')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('chats');
    }
};
