<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->index('employee_id');
            $table->index('tenant_id');
        });

        Schema::table('points', function (Blueprint $table) {
            $table->index('employee_id');
            $table->index('department_id');
            $table->index('category');
            $table->index('updated_at');
            $table->index('tenant_id');
        });

        Schema::table('targets', function (Blueprint $table) {
            $table->index('department_id');
            $table->index('category');
            $table->index('updated_at');
            $table->index('tenant_id');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tables', function (Blueprint $table) {
            //
        });
    }
};
