<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_leader_boards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->Integer('earned_points');
            $table->Integer('rank');
            $table->string('month_year');
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();

            // Define foreign key for department_id
            $table->foreign('employee_id')
                ->references('employee_id')->on('employees')  // Reference to employees table
                ->onDelete('set null');

            // Define foreign keys
            $table->foreign('tenant_id')
                ->references('id')->on('admins')  // Reference to admins table
                ->onDelete('cascade');                 // Delete department if dealership is deleted

            $table->index('employee_id');
            $table->index('earned_points');
            $table->index('rank');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_leader_boards');
    }
};
