<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('department_leader_boards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('department_id')->nullable();
            $table->Integer('earned_points');
            $table->Integer('total_points');
            $table->Integer('rank');
            $table->string('month_year');
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();

            // Define foreign key for department_id
            $table->foreign('department_id')
                ->references('id')->on('departments')  // Reference to departments table
                ->onDelete('set null');

            // Define foreign keys
            $table->foreign('tenant_id')
                ->references('id')->on('admins')  // Reference to admins table
                ->onDelete('cascade');                 // Delete department if dealership is deleted

            $table->index('department_id');
            $table->index('earned_points');
            $table->index('rank');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('department_leader_boards');
    }
};
