<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('points', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id');
            $table->unsignedBigInteger('department_id')->nullable();
            $table->unsignedBigInteger('target_id')->nullable();
            $table->string('category');
            $table->integer('points');
            $table->string('vin_no');
            $table->enum('status', ['Redeemed', 'Rejected', 'Pending']);
            $table->string('detail')->nullable();
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();

            // Define foreign key for department_id
            $table->foreign('department_id')
                ->references('id')->on('departments')  // Reference to departments table
                ->onDelete('set null');                 // Set to null if the department is deleted

            // Define foreign key for employee_id
            $table->foreign('employee_id')
                ->references('employee_id')->on('employees')    // Reference to employees table's employee_id column
                ->onDelete('cascade');                         // Delete points if the employee is deleted

            // Define foreign key for target_id
            $table->foreign('target_id')
                ->references('id')->on('targets')      // Reference to targets table
                ->onDelete('set null');                // Set to null if the target is deleted

            // Define foreign keys
            $table->foreign('tenant_id')
                ->references('id')->on('admins')  // Reference to admins table
                ->onDelete('cascade');                 // Delete department if dealership is deleted

        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('points');
    }
};
