<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('targets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('department_id');
            $table->unsignedBigInteger('product_id')->nullable();
            $table->string('custom')->nullable();
            $table->string('category');
            $table->integer('quantity');
            $table->integer('progress')->nullable();
            $table->enum('status', ['0','1', '2']);
            $table->date('last_date');
            $table->date('completion_date')->nullable();
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();

            // Define foreign keys
            $table->foreign('department_id')
                ->references('id')->on('departments')  // Reference to departments table
                ->onDelete('cascade');                 // Delete target if department is deleted

            $table->foreign('product_id')
                ->references('id')->on('products')     // Reference to products table
                ->onDelete('cascade');                 // Delete target if product is deleted

            // Define foreign keys
            $table->foreign('tenant_id')
                ->references('id')->on('admins')  // Reference to admins table
                ->onDelete('cascade');                 // Delete department if dealership is deleted


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('targets');
    }
};
