<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {

            $table->id('employee_id');
            $table->string('name');
            $table->date('dob')->nullable();
            $table->string('nationality')->nullable();
            $table->enum('marital', ['Married', 'Unmarried'])->nullable();
            $table->enum('gender', ['Male', 'Female', 'Other'])->nullable();
            $table->string('email')->unique();
            $table->string('phn', 20)->nullable();
            $table->string('password');
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('address')->nullable();
            $table->integer('zip')->nullable();
            $table->unsignedBigInteger('department_id')->nullable();
            $table->enum('role', ['Manager', 'Admin', 'Employee'])->nullable();
            $table->string('category')->nullable();
            $table->enum('status', ['2', '1', '0'])->nullable();
            $table->string('image')->nullable();
            $table->string('emoji', 10)->nullable();
            $table->unsignedBigInteger('tenant_id');
            $table->text('slug')->unique();
            $table->timestamps();

            // Define the foreign key constraint in case Department is deleted
            $table->foreign('department_id')
                ->references('id')
                ->on('departments')
                ->onDelete('set null');

            // Define foreign keys
            $table->foreign('tenant_id')
                ->references('id')->on('admins')  // Reference to admins table
                ->onDelete('cascade');                 // Delete Employee if dealership is deleted
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};
