<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
//            $table->unsignedBigInteger('department_id')->nullable(); // Make department_id nullable
            $table->string('name');
            $table->string('code');
            $table->string('number');
            $table->enum('status', ['2', '1', '0']);
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();

            // Define foreign keys
            $table->foreign('tenant_id')
                ->references('id')->on('admins')  // Reference to admins table
                ->onDelete('cascade');                 // Delete department if dealership is deleted

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
