<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('departments', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('no_of_emp');
            $table->string('role');
            $table->string('categories');
            $table->text('slug')->unique();
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();

            // Define foreign keys
            $table->foreign('tenant_id')
                ->references('id')->on('admins')  // Reference to admins table
                ->onDelete('cascade');                 // Delete department if dealership is deleted

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('departments');
    }
};
