<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserEmojiAssignment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'assigned_by',
        'emoji_id',
        'message',
        'tenant_id'
    ];

    // Relationship with User (who receives the emoji/GIF)
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // Relationship with User (who assigned the emoji/GIF)
    public function assignedBy()
    {
        return $this->belongsTo(User::class, 'assigned_by');
    }

    // Relationship with CustomEmoji
    public function emoji()
    {
        return $this->belongsTo(CustomEmoji::class, 'emoji_id');
    }

    // Relationship with Tenant
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    // Scope for tenant
    public function scopeForTenant($query, $tenantId)
    {
        return $query->where('tenant_id', $tenantId);
    }

    // Scope for user
    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }
}