<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class SuperAdmin extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'address',
        'image',
        'status',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Get all tenants in the system
     */
    public function getAllTenants()
    {
        return Tenant::all();
    }

    /**
     * Get all admins across all tenants
     */
    public function getAllAdmins()
    {
        return Admin::with('tenant')->get();
    }

    /**
     * Get specific tenant with its admins
     */
    public function getTenantWithAdmins($tenantId)
    {
        return Tenant::with('admins')->find($tenantId);
    }

    // Relationship with emoji assignments
    public function emojiAssignments()
    {
        return $this->morphMany(EmojiAssignment::class, 'assignable');
    }
}