<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Cviebrock\EloquentSluggable\Sluggable;
use App\Traits\BelongsToTenant;


class Employee extends Authenticatable
{

    use HasApiTokens, HasFactory, Notifiable, Sluggable;
    use BelongsToTenant;

    protected $fillable = [
        'employee_id',
        'name', 'email', 'password', 'department_id',
        'role', 'status', 'image', 'emoji', 'dob',
        'phn', 'gender', 'marital', 'nationality',
        'city', 'state', 'zip', 'address', 'category',
        'tenant_id', 'slug'
    ];

    protected $primaryKey = 'employee_id';

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }
// Add this relationship to your existing Employee model
public function pushSubscriptions()
{
    return $this->hasMany(PushSubscription::class, 'employee_id', 'employee_id');
}
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => ['name']
            ]
        ];
    }

public function conversations()
{
    return $this->belongsToMany(Conversation::class, 'conversation_participants', 'employee_id', 'conversation_id')
                ->withPivot('role', 'joined_at', 'last_read_at', 'is_muted')
                ->withTimestamps();
}

public function messages()
{
    return $this->hasMany(Message::class, 'sender_id', 'employee_id');
}

    public function sentMessages()
    {
        return $this->hasMany(Message::class, 'sender_id');
    }

public function unreadMessagesCount()
{
    return $this->conversations->sum(function ($conversation) {
        return $conversation->getUnreadCountForEmployee($this->employee_id);
    });
}

// Relationship with emoji assignments
public function emojiAssignments()
{
    return $this->morphMany(EmojiAssignment::class, 'assignable');
}
}
