<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmojiAssignment extends Model
{
    use HasFactory;

    protected $fillable = [
        'assignable_id',
        'assignable_type',
        'assigned_by_id',
        'assigned_by_type',
        'emoji_id',
        'message',
        'tenant_id'
    ];

    // Polymorphic relationship - who receives the emoji/GIF (Employee, Admin, etc.)
    public function assignable()
    {
        return $this->morphTo();
    }

    // Polymorphic relationship - who assigned the emoji/GIF (Employee, Admin, etc.)
    public function assignedBy()
    {
        return $this->morphTo();
    }

    // Relationship with CustomEmoji
    public function emoji()
    {
        return $this->belongsTo(CustomEmoji::class, 'emoji_id');
    }

    // Relationship with Tenant (through Admin table)
    public function tenant()
    {
        return $this->belongsTo(Admin::class, 'tenant_id');
    }

    // Scope for tenant
    public function scopeForTenant($query, $tenantId)
    {
        return $query->where('tenant_id', $tenantId);
    }

    // Scope for assignable (Employee, Admin, etc.)
    public function scopeForAssignable($query, $assignableId, $assignableType)
    {
        return $query->where('assignable_id', $assignableId)
                    ->where('assignable_type', $assignableType);
    }
}