<?php

namespace App\Models;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use App\Traits\BelongsToTenant;

class Department extends Model
{
    use Sluggable;
    use BelongsToTenant;

    protected $guarded = [
        'id',
        'created_at'
    ];

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => ['name']
            ]
        ];
    }

    //H-B : Relation between Employees and Department
    public function employees()
    {
        return $this->hasMany(Employee::class, 'department_id');
    }

}

