<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConversationParticipant extends Model
{
    use HasFactory;

    protected $fillable = [
        'conversation_id', 'employee_id', 'admin_id', 'role', 
        'joined_at', 'last_read_at', 'is_muted'
    ];

    protected $casts = [
        'joined_at' => 'datetime',
        'last_read_at' => 'datetime',
        'is_muted' => 'boolean',
    ];

    public function conversation()
    {
        return $this->belongsTo(Conversation::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id', 'employee_id');
    }
 public function admin()
    {
        return $this->belongsTo(Admin::class);
    }
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    public function markAsRead()
    {
        $this->update(['last_read_at' => now()]);
    }
    // Get participant info
    public function getParticipantAttribute()
    {
        if ($this->admin_id) {
            return $this->admin;
        }
        return $this->employee;
    }

    public function getParticipantTypeAttribute()
    {
        return $this->admin_id ? 'admin' : 'employee';
    }
}