<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Chat extends Model
{
    protected $fillable = [
        'sender_id', 'receiver_id', 'message', 'attachment', 'status'
    ];

    public function sender()
    {
        return $this->belongsTo(Employee::class, 'sender_id', 'employee_id');
    }

    public function receiver()
    {
        return $this->belongsTo(Employee::class, 'receiver_id', 'employee_id');
    }
    
}
