<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\BelongsToTenant;

class Category extends Model
{
//    use HasFactory;

    use BelongsToTenant;
    protected $fillable = ['department_id', 'category_name'];

    //H-B: Relation between Categories and Department
    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }
}
