<?php
// app/Http/Controllers/TestController.php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class TestController extends Controller
{
    /**
     * Test route to check if web routes and middleware are working
     */
    public function testPush(Request $request): JsonResponse
    {
        try {
            $authenticatedUser = $request->attributes->get('authenticated_user');
            $tenantId = $request->attributes->get('tenant_id');
            
            return response()->json([
                'success' => true,
                'message' => 'Web route is working',
                'user' => $authenticatedUser?->email ?? $authenticatedUser?->name ?? 'No user',
                'user_type' => get_class($authenticatedUser ?? new \stdClass()),
                'tenant_id' => $tenantId ?? 'No tenant',
                'csrf_token' => csrf_token(),
                'middleware_working' => true
            ]);
            
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error in test route',
                'error' => $e->getMessage(),
                'csrf_token' => csrf_token()
            ], 500);
        }
    }
}