<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Department;
use App\Models\Product;


class ProductController extends Controller
{
    protected $owner;

    //H - B : Constructor
    public function __construct()
    {
        // Use middleware to delay session initialization
        $this->middleware(function ($request, $next) {
            $this->owner = session('owner');
            return $next($request);
        });
    }

    // H-B: Product Listing Page
    public function listing(){
        $departments = Department::where('tenant_id', $this->owner['id'])->get();
        $products = Product::where('tenant_id', $this->owner['id'])->get();
        return view('SuperAdmin.products.products',compact('products'));
    }

    // H - B : Add and Edit Product
    public function addAndEditProduct(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required',
            'number' => 'required',
            'status' => 'required',
        ]);


        try {

            $prod = Product::find($request->id);
            $data = $request->only([
                'name', 'status', 'number'
            ]);
            $data['tenant_id'] = $this->owner['id'];

            if($prod)
            {
                $product = $prod->update($data);
            } else {
                $lastProduct = Product::latest('id')->first();
                $lastProductCode = $lastProduct ? (int)$lastProduct->code : 0;
                $newProductCode = str_pad($lastProductCode + 1, 4, '0', STR_PAD_LEFT);
                $data['code'] = $newProductCode;
                $product = Product::create($data);
            }

            if($product)
            {
                return response()->json([
                    'Error' => false,
                    'Message' => "Product Added Successfully",
                ]);
            } else {
                return response()->json([
                    'Error' => true,
                    'Message' => "Product can't be Added!",
                ]);
            }
        }
        catch(\Throwable $t)
        {
            return response()->json([
                'Error'=>true,
                'Message'=>$t->getMessage(),
            ]);
        }
    }

    // H - B : Delete Product
    public function deleteProduct(Request $request)
    {
        try {
            $delete = Product::where('id', $request->id)->delete();
            if($delete)
            {
                return response()->json([
                    'Error' => false,
                    'Message' => 'Product Deleted Successfully!',
                ]);
            } else{

                return response()->json([
                    'Error' => true,
                    'Message' => 'Product Delete Failed!',
                ]);
            }

        } catch (\Throwable $t)
        {
            return response()->json([
                'Error' => true,
                'Message' => $t->getMessage(),
            ]);
        }
    }
}
