<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Department;
use App\Models\Employee;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use function Laravel\Prompts\error;

class ManagerController extends Controller
{

    protected $owner;

    //H - B : Constructor
    public function __construct()
    {
        // Use middleware to delay session initialization
        $this->middleware(function ($request, $next) {
            $this->owner = session('owner');
            return $next($request);
        });
    }

    // H - B: MANAGER LISTING
    public function listing()
    {
        $departments = Department::where('tenant_id', $this->owner['id'])->get();
        $employees = Employee::where('tenant_id', $this->owner['id'])->get();
        return view('SuperAdmin.manager.manager', compact('employees', 'departments'));
    }

    // H - B: ManagerMiddleware Add and Edit
    public function addAndEditManager(Request $request)
    {
        try {
            $validate = $request->validate([
                'employee_id' => 'required',
                'department' => 'required',
                'status' => 'required',
            ]);

            //It is strategically placed Before Updating
            if( $request->old_mngr !== null )
            {
                $employee = Employee::where('tenant_id', $this->owner['id'])
                    ->where('employee_id', $request->old_mngr)->update([
                    'department_id'=>null,
                    'role'=>'Employee',
                    'category'=>null,
                    'status'=>'1',
                ]);
            }

            $employee = Employee::where('tenant_id', $this->owner['id'])
                ->where('employee_id', $request->employee_id)->update([
                'department_id' => $request->department,
                'role' => 'Manager',
                'category' => null,
                'status' => $request->status
            ]);

            $count = Employee::where('tenant_id', $this->owner['id'])
                ->where('department_id', $request->department)->count();
            $test = Department::where('id', $request->department)->update(['no_of_emp' => $count]);

            if($employee)
            {
                return response()->json([
                    'Error' => false,
                    'Message' => 'Manager Added Successfully!',
                ]);
            }
            else
            {
                return response()->json([
                    'Error' => true,
                    'Message' => 'Error: Attempt Failed!',
                ]);
            }
        }
        catch(\Throwable $t)
        {
            return response()->json([
                'Error' => false,
                'Message' => $t->getMessage(),
            ]);
        }
    }

    //H-B: Manager Delete
    public function deleteManager(Request $request)
    {
        try {
            $employee = Employee::where('tenant_id', $this->owner['id'])
                ->where('employee_id', $request->id)->first();
            $depart = $employee->department_id;
            $employee->update([
                'department_id' => null,
                'role' => 'Employee',
                'category' => null,
                'status' => '1',
            ]);

            $count = Employee::where('tenant_id', $this->owner['id'])
                ->where('department_id', $depart)->count();
            $test = Department::where('id', $request->department)->update(['no_of_emp' => $count]);

            if ($employee) {
                return response()->json([
                    'Error' => false,
                    'Message' => 'Manager Removed Successfully!',
                ]);
            } else {
                return response()->json([
                    'Error' => true,
                    'Message' => 'Error: Attempt Failed!',
                ]);
            }
        } catch (\Throwable $t) {
            return response()->json([
                'Error' => true,
                'Message' => $t->getMessage(),
            ]);
        }
    }
}
