<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\Points;
use App\Models\Target;
use Illuminate\Http\Request;

//Models
use App\Models\Department;
use App\Models\category;
use App\Models\Employee;



class DepartmentController extends Controller
{

    protected $owner;

    //H - B : Constructor
    public function __construct()
    {
        // Use middleware to delay session initialization
        $this->middleware(function ($request, $next) {
            $this->owner = session('owner');
            return $next($request);
        });
    }

    // H-B : Departments page view
    public function view_page()
    {
        $departments = Department::where('tenant_id', $this->owner['id'])->get();
        $employees = Employee::where('tenant_id', $this->owner['id'])->get();

        // $depart_employees = Employee::where('department_id' , $department->id)->get();
        return view('SuperAdmin.department.department' , compact('departments' , 'employees' ));
    }

    // H-B : Post Department
    public function postDepartment(Request $request)
    {
        // Validate the request data
        $validation = $request->validate([
            'name' => 'required',
            'no_of_emp' => 'required',
            'role' => 'required',
            'category' => 'required',
        ]);

        $category = null;
        $cate = json_decode($request->category, true);
        foreach ($cate as $cat)
        {
            $category[] = ucfirst($cat['value']);
        }
        try {
            // Create the Department entry
            $department = Department::create([
                'name' => $request->name,
                'no_of_emp' => '0',
                'role' => $request->role,
                'categories' => json_encode($category),
                'tenant_id' => $this->owner['id'],
            ]);

            //Updating the Role of Employee to Manager
            $emp = Employee::find($request->manager);
            if($department && !empty($emp))
            {
                $emp->update([
                    'department_id' => $department->id,
                    'role' => 'Manager',
                    'category' => null,
                    'status' => "2"
                ]);
                $department->update(['no_of_emp' => '1']);
            }
            // Return a successful response
            return response()->json([
                'Error' => false,
                'Message' => 'Department Added Successfully!',
            ]);
        }
        catch(\Throwable $t)
        {
            // Return a Error response
            return response()->json([
                'Error' => true,
                'Message' => $t->getMessage(),
            ]);
        }
    }


    // H-B : Edit Department
    public function editDepartment(Request $request) {

        // Validate the request data
        $validation = $request->validate([
            'name' => 'required',
            'no_of_emp' => 'required',
            'role' => 'required',
            'category' => 'required',
        ]);

        $category = null;
        $cate = json_decode($request->category, true);
        foreach ($cate as $cat) {
            $category[] = ucfirst($cat['value']);
        }

        //Edit and Delete of Categories
        $oldCates = json_decode($request->oldCategories, true);
        $newCates = json_decode($request->newCategories, true);
        $delCates = json_decode($request->delCategories, true);

        try {
            // Find the departmdel
            $dep = Department::where('id', $request->id)
            ->where('tenant_id', $this->owner['id'])->first();
            if (!$dep) {
                return response()->json([
                    'Error' => true,
                    'Message' => 'Department not found!',
                ], 404);
            }

            // Update the department attributes
            $dep->update([
                'name' => $request->name,
                'role' => $request->role,
                'categories' => $category,
            ]);

            //Update Manager
            if($request->oldMngr != $request->manager)
            {
               if(!empty($request->oldMngr))
                {
                    $old_mngr = Employee::find($request->oldMngr)->update([
                        'department_id' => null,
                        'role' => 'Employee',
                        'category' => null,
                        'status' => '1',
                    ]);
                }

                if(!empty($request->manager))
                {
                    $new_mngr = Employee::find($request->manager)->update([
                        'department_id' => $request->id,
                        'role' => 'Manager',
                        'category' => null,
                        'status' => '2',
                    ]);
                }
            }

            $empCount = Employee::where('tenant_id', $this->owner['id'])
                ->where('department_id', $request->id)->count();
            $dep->update(['no_of_emp' => $empCount]);

            //Update Categories
            //Iterate over the old categories to check for Changes
            foreach ($oldCates as $index => $oldcat) {
                if ($oldcat != $newCates[$index]) {
                    // Update the employees with the old category to the new category
                    $employees = Employee::where('department_id', $request->id)
                        ->where('tenant_id', $this->owner['id'])
                        ->where('category', $oldcat) // Check if the employee has the old category
                        ->update(['category' => $newCates[$index]]); // Update to the new category

                    $points = Points::where('tenant_id', $this->owner['id'])
                        ->where('department_id', $request->id)
                        ->where('category', $oldcat)
                        ->update(['category' => $newCates[$index]]);

                    $targets = Target::where('tenant_id', $this->owner['id'])
                        ->where('department_id', $request->id)
                        ->where('category', $oldcat)
                        ->update(['category' => $newCates[$index]]);
                }
            }

            //Iterate over the Deleted Categories to check for Removed ones
            if (!empty($delCates )) {
                foreach ($delCates as $delcat) {
                    // Update the employees with the old category to the new category
                    $employees = Employee::where('department_id', $request->id)
                        ->where('tenant_id', $this->owner['id'])
                        ->where('category', $delcat) // Check if the employee has the old category
                        ->update(['category' => null]); // Update to the new category
                    $points = Points::where('tenant_id', $this->owner['id'])
                        ->where('department_id', $request->id)
                        ->where('category', $delcat)
                        ->update(['category' => null]);

                    $targets = Target::where('tenant_id', $this->owner['id'])
                        ->where('department_id', $request->id)
                        ->where('category', $delcat)
                        ->update(['status' => '1']);
                        //->update(['category' => $newCates[$index]]);      //Ask Client About this one.
                }
            }

            return response()->json([
                'Error' => false,
                'Message' => 'Department Updated Successfully!'
            ]);
        }
        catch (\Throwable $t)
        {
            return response()->json([
                'Error' => true,
                'Message' => $t->getMessage(),
            ],404);
        }
    }


    // H-B : Service Department page view
    public function serviceDepartment($department_slug)
    {
        $path = request()->path();
        $pathParts = explode('/', $path);
        $actualSlug = end($pathParts); // This should be "sales" from your URL
        
        // dd([
        //     'parameter_from_route' => $department_slug, 
        //     'extracted_from_path' => $actualSlug,
        //     'path' => $path,
        //     'path_parts' => $pathParts
        // ]);
        $department = Department::where('slug' , $actualSlug)
            ->where('tenant_id', $this->owner['id'])->first();
        $admin_count = Employee::where('department_id', $department->id)
            ->where('role' , 'admin')->count();

        $manager_count = Employee::where('department_id', $department->id)
            ->where('role' , 'manager')->count();

        $departments = Department::where('tenant_id', $this->owner['id'])->get();

        $employees = Employee::where('tenant_id', $this->owner['id'])->get();

        $categories = json_decode($department->categories, true);
        array_unshift($categories, 'Manager', 'Admin');

        $targets = Target::where('targets.department_id', $department->id)  // Explicitly mention 'targets' table
        ->where('targets.tenant_id', $this->owner['id'])  // Explicitly mention 'targets' table
        ->whereNot('targets.status', '1')
        ->leftJoin('products', 'targets.product_id', '=', 'products.id')
            ->select('targets.*', 'products.name as product')
            ->orderBY('targets.category')
            ->get();

        return view('SuperAdmin.department.service.serviceDepartment' , compact('department' , 'employees' , 'categories' , 'admin_count' , 'manager_count' , 'departments', 'targets'));
    }

    // H-B : Sales Department page view
    public function salesDepartment()
    {
        return view('SuperAdmin.department.sales.saleDepartment');
    }

    // H-B : Parts Department page view
    public function partsDepartment()
    {
        return view('SuperAdmin.department.parts.partsDepartment');
    }

    // H-B : finance Department page view
    public function financeDepartment()
    {
        return view('SuperAdmin.department.finance.financeDepartment');
    }

}
