namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\Tenant;
use Illuminate\Http\Request;

class TenantController extends Controller
{
    public function index()
    {
        $tenants = Tenant::withCount(['employees', 'departments'])->get();
        return view('super-admin.tenants.index', compact('tenants'));
    }
    
    public function create()
    {
        return view('super-admin.tenants.create');
    }
    
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'domain' => 'required|string|unique:tenants,domain',
        ]);
        
        $tenant = Tenant::create($request->all());
        
        // Initialize tenant with required data
        $this->initializeTenant($tenant);
        
        return redirect()->route('super-admin.tenants.index')
            ->with('success', 'Tenant created successfully.');
    }
    
    private function initializeTenant(Tenant $tenant)
    {
        // Create default admin
        \App\Models\Admin::create([
            'name' => 'Admin',
            'email' => 'admin@' . $tenant->domain,
            'password' => bcrypt('password'),
            'tenant_id' => $tenant->id,
        ]);
        
        // Create default departments
        $defaultDepartments = ['Sales', 'Service', 'Parts', 'Finance'];
        
        foreach ($defaultDepartments as $name) {
            \App\Models\Department::create([
                'name' => $name,
                'no_of_emp' => 0,
                'role' => 'Department',
                'categories' => json_encode(['Default']),
                'tenant_id' => $tenant->id,
            ]);
        }
    }
}