<?php

namespace App\Http\Controllers\Manager;

use App\Http\Controllers\Controller;
use App\Models\Department;
use App\Models\Employee;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    protected $mngr;

    //H - B : Constructor
    public function __construct()
    {
        // Use middleware to delay session initialization
        $this->middleware(function ($request, $next) {
            $this->mngr = session('ismngr');
            return $next($request);
        });
    }

    // H-B: Admin Add and Edit
    public function addAndEditAdmin(Request $request)
    {
        $validate = $request->validate([
            'employee_id' => 'required',
            'department' => 'required',
            'status' => 'required',
            'category' => 'required',
        ]);

        try {
            $employee = Employee::where('employee_id', $request->employee_id)->update([
                'department_id'=>$request->department,
                'role'=> 'Admin',
                'status'=>$request->status,
                'category' => $request->category,
            ]);

            $count = Employee::where('tenant_id', $this->mngr['tenant_id'])
                ->where('department_id', $request->department)->count();
            $test = Department::where('id', $request->department)->update(['no_of_emp' => $count]);

            if($employee)
            {
                return response()->json([
                    'Error' => false,
                    'Message' => 'Admin Added Successfully!',
                ]);
            }
            else
            {
                return response()->json([
                    'Error' => true,
                    'Message' => 'Error: Attempt Failed!',
                ]);
            }
        }
        catch(\Throwable $t)
        {
            return response()->json([
                'Error' => false,
                'Message' => $t->getMessage(),
            ]);
        }
    }

    // H-B: Admin Delete
    public function deleteAdmin(Request $request)
    {
        $validate = $request->validate([
            'id'=>'required'
        ]);

        try {
            $employee = Employee::find($request->id);
            if($employee)
            {
                $employee->update([
                    'department_id'=> $this->mngr['department_id'],
                    'role'=>'Employee',
                    'category'=>null,
                    'status'=>'1'
                ]);

                return response()->json([
                    'Error' => false,
                    'Message' => "Admin removed Successfully",
                ]);
            }
            else
            {
                return response()->json([
                    'Error'=>true,
                    'Message' => "Admin not Found!"
                ]);
            }
        }
        catch(\Throwable $t)
        {
            return response()->json([
                'Error' => true,
                'Message' => $t->getMessage(),
            ]);

        }
    }

}
