<?php
namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use App\Models\YoutubeVideo;
use App\Services\YouTubeService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class VideosController extends Controller
{
    public function index()
    {
        $videos = YoutubeVideo::orderBy('created_at', 'desc')
            ->paginate(10);

        return view('Employee.videoslist', compact('videos'));
    }

    public function show(YoutubeVideo $video)
    {
        return view('Employee.video-show', compact('video'));
    }
}